%	fdm1d.m
%     iterative one-dimensional finite difference solution
%
%     the following data are used:
%     vk = vector of all potentials, including boundaries
%     v  = vector of potentials at internal nodes
%     n1x= number of divisions in the x direction
%     vx1,vx2, boundary potentials on the left and right boundaries
%     eps, error tolerance per node
%     r0, charge density - either uniform or constant in the relation
%     r0(x^2-d*x) (see Figure 6.13) in Example 6.1
%     cx1, cx2, coordinates of charged region (unless it is uniform)
%
%  enter data
clear
        disp('in the data entry that follows use a space to separate input values')
        disp('when multiple values are required they must be entered as an array, including the brackets')
        [c1]=input('enter left and right boundary coordinate as follows: --> [xl xr] -->  ')
      xl=c1(1);
      xr=c1(2);
        n1x=input('enter number of divisions in the mesh -->  ')
        c1=input('enter boundary conditions on left and right boundaries - [v1 v2] -->  ')
      vx1=c1(1);
      vx2=c1(2);
        erd=input('enter relative permittivity of solution domain -->  ')
        ii=input('enter 1 if const. charge density, 0 if not -->  ')
      if ii==0
         c1=input('enter left and right charge region coordinates [x1 x2] -->  ')
       cx1=c1(1);
       cx2=c1(2);
         erc=input('enter relative permittivity of charge region -->  ')
      end
         r0=input('enter charge density r0 -->  ')
         eps=input('enter required error tolerance -->  ')
      if ii==1
      cx1=xl;
      cx2=xr;
      erc=erd;
      end
      n1=n1x+1;
      for i=1:n1
      vk(i)=0.0;
      ro(i)=0.0;
      end
        dx=(xr-xl)/n1x;
        for i=1:n1
            x(i)=xl+(i-1)*dx;
        end        
      for i=1:n1+1
        if ii==0
            dlx=dx*(i-1);
                if (dlx>=cx1)&(dlx<=cx2)
                    ro(i)=r0*dx*(i-1)*(dx*(i-1)-(xr-xl));
                end
        else
            ro(i)=r0;
        end
      end
% set boundary conditions on left and right boundaries
      vk(1)=vx1;
      vk(n1)=vx2;     
% start iterations
      e0=8.854e-12;
      n=n1-2;
      kk=0;
      vv=0.0;
      vv1=eps*1e6;

    while abs(vv-vv1)>eps
        vv1=vv;
        vv=0.0;
      for i=2:n1-1
            vk(i)=(vk(i-1)+vk(i+1))/2.0+ro(i)*dx*dx/(2*erc*e0);
            vv=vv+vk(i);
      end
      vv=vv/n;
      kk=kk+1;
    end
%     the error criterion has been met. the correct solution is in vk
            n=1;
            v(1)=vx1;
      for i=2:n1-1
            n=n+1;
            v(n)=vk(i);
      end
            n=n+1;
            v(n)=vx2;
% calculate the electric field between each two potentials
      for i=1:n1-1
            e(i)=-((v(i+1)-v(i)))/dx;
      end     
      n=1;
      xx(n)=x(1);
      ee(n)=0;
      n=n+1;
      xx(n)=x(1)
      ee(n)=e(1)
      for i=2:n1-1
          n=n+1;
          xx(n)=x(i);
          ee(n)=e(i-1);
          n=n+1;
          xx(n)=x(i);
          ee(n)=e(i);
      end
      n=n+1;
      xx(n)=x(n1);
      ee(n)=e(n1-1);
% plot potential
scrsz = get(0,'ScreenSize');
figure('position',[1 scrsz(4)/2 scrsz(3)/2 scrsz(4)/2])
      plot(x,v)
      xlabel('distance [m]')
      ylabel('voltage [V]')
      title({'Potential distribution in the solution domain'})
% plot electric field
scrsz = get(0,'ScreenSize');
figure('position',[scrsz(3)/2 scrsz(4)/2 scrsz(3)/2 scrsz(4)/2])
      plot(xx,ee)
      xlabel('distance [m]')
      ylabel('Electric field intensity [V/m]')
      title({'Electric field distribution in the solution domain'})
% The following statement lists the voltage at the nodes of the mesh
% Theis statement may be commented if the list is not needed
       v
% The following statement lists the electric field intensity between every
% two nodes. This may be commented if the values are not needed
      ee